

scr.m = matrix(c(0.1, 0.5, 0.5, 0.9,
                 0.1, 0.5, 0.1, 0.5,
                 0.5, 0.9, 0.5, 0.9,
                 0.5, 0.9, 0.1, 0.5
                 
),
ncol = 4, byrow = T
)


#plotting pulse (4A)
file.name <- "/data/figure/figure4/figure4_MNase_cut_pulse.png"
png(file = file.name, width = 10, height = 7, units = "in", res = 300, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 0, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles
mycolor = natparks.pals(name="KingsCanyon",n=6,type="discrete")
screen(1)
par(mar = c(0.5,4,4,0.5), cex=1.1) 
plot(seq(-200,200,1),wt_nuc_left_cut.list[[1]],main="",pch=20,cex=0.5,ylab="Count",col=mycolor[3],xaxt="n",ylim=c(0,200000))
points(seq(-200,200,1),wt_nuc_right_cut.list[[1]],pch=20,cex=0.5,col=mycolor[4])

screen(2)
par(mar = c(4,4,0.5,0.5), cex=1.1) 
plot(seq(-200,200,1),wt_small_left_cut.list[[1]],main="",pch=20,cex=0.5,ylab="Count",col=mycolor[3],xlab="Distance from nucleosome dyad (bp)",xaxt="n",ylim=c(0,200000))
points(seq(-200,200,1),wt_small_right_cut.list[[1]],pch=20,cex=0.5,col=mycolor[4])
axis(side=1, at=c(-150,-75,0,75,150), labels=c(-150,-75,0,75,150))

screen(3)
par(mar = c(0.5,0.5,4,4), cex=1.1) 
plot(seq(-200,200,1),cac_nuc_left_cut.list[[1]],main="",pch=20,cex=0.5,col=mycolor[3],xaxt="n",yaxt="n",ylim=c(0,200000))
points(seq(-200,200,1),cac_nuc_right_cut.list[[1]],pch=20,cex=0.5,col=mycolor[4])

screen(4)
par(mar = c(4,0.5,0.5,4), cex=1.1) 
plot(seq(-200,200,1),cac_small_left_cut.list[[1]],main="",pch=20,cex=0.5,col=mycolor[3],xlab="Distance from nucleosome dyad (bp)",xaxt="n",yaxt="n",ylim=c(0,200000))
points(seq(-200,200,1),cac_small_right_cut.list[[1]],pch=20,cex=0.5,col=mycolor[4])
axis(side=1, at=c(-150,-75,0,75,150), labels=c(-150,-75,0,75,150))

dev.off()


#plotting chase (4B)
file.name <- "/data/figure/figure4/figure4_MNase_cut_chase.png"
png(file = file.name, width = 10, height = 7, units = "in", res = 300, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 0, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles
mycolor = natparks.pals(name="KingsCanyon",n=6,type="discrete")
screen(1)
par(mar = c(0.5,4,4,0.5), cex=1.1) 
plot(seq(-200,200,1),wt_nuc_left_cut.list[[5]],main="",pch=20,cex=0.5,ylab="Count",col=mycolor[3],xaxt="n",ylim=c(0,300000))
points(seq(-200,200,1),wt_nuc_right_cut.list[[5]],pch=20,cex=0.5,col=mycolor[4])

screen(2)
par(mar = c(4,4,0.5,0.5), cex=1.1) 
plot(seq(-200,200,1),wt_small_left_cut.list[[5]],main="",pch=20,cex=0.5,ylab="Count",col=mycolor[3],xlab="Distance from nucleosome dyad (bp)",xaxt="n",ylim=c(0,300000))
points(seq(-200,200,1),wt_small_right_cut.list[[5]],pch=20,cex=0.5,col=mycolor[4])
axis(side=1, at=c(-150,-75,0,75,150), labels=c(-150,-75,0,75,150))

screen(3)
par(mar = c(0.5,0.5,4,4), cex=1.1) 
plot(seq(-200,200,1),cac_nuc_left_cut.list[[5]],main="",pch=20,cex=0.5,col=mycolor[3],xaxt="n",yaxt="n",ylim=c(0,300000))
points(seq(-200,200,1),cac_nuc_right_cut.list[[5]],pch=20,cex=0.5,col=mycolor[4])

screen(4)
par(mar = c(4,0.5,0.5,4), cex=1.1) 
plot(seq(-200,200,1),cac_small_left_cut.list[[5]],main="",pch=20,cex=0.5,col=mycolor[3],xlab="Distance from nucleosome dyad (bp)",xaxt="n",yaxt="n",ylim=c(0,300000))
points(seq(-200,200,1),cac_small_right_cut.list[[5]],pch=20,cex=0.5,col=mycolor[4])
axis(side=1, at=c(-150,-75,0,75,150), labels=c(-150,-75,0,75,150))

dev.off()


#subnucleosome left right separate (4C)
file.name <- "/data/figure/figure4/figure4_MNase_cut_cac_small_separate.png"
png(file = file.name, width = 10, height = 7, units = "in", res = 300, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 0, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles
mycolor = natparks.pals(name="KingsCanyon",n=6,type="discrete")

screen(2)
par(mar = c(4,4,0.5,0.5), cex=1.1) 
plot(seq(-200,200,1),cac_small_cut.list[[3]][[1]],main="",pch=20,cex=0.5,ylab="Count",col=mycolor[3],xlab="Distance from nucleosome dyad (bp)",xaxt="n",ylim=c(0,200000))
points(seq(-200,200,1),cac_small_cut.list[[4]][[1]],pch=20,cex=0.5,col=mycolor[4])
axis(side=1, at=c(-150,-75,0,75,150), labels=c(-150,-75,0,75,150))

screen(4)
par(mar = c(4,0.5,0.5,4), cex=1.1) 
plot(seq(-200,200,1),cac_small_cut.list[[1]][[1]],main="",pch=20,cex=0.5,col=mycolor[3],xlab="Distance from nucleosome dyad (bp)",xaxt="n",yaxt="n",ylim=c(0,200000))
points(seq(-200,200,1),cac_small_cut.list[[2]][[1]],pch=20,cex=0.5,col=mycolor[4])
axis(side=1, at=c(-150,-75,0,75,150), labels=c(-150,-75,0,75,150))

dev.off()












